--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI - must be in the order than the source class ids
fn DisplaySourceName =
(
	--#("Omnilight", "Target Spot", "Free Directional Light", "Free Spot", "Target Directional Light")
	#("Omnilight")
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	--#(48, 48, 48, 48, 48) --Light 
	#(48) --Light 
)

--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
--	#(#(0x1011L, 0x0L) /*Omnilight*/,#(0x1012L, 0x0L)/*Target Spot*/, #(0x1013L, 0x0L)/*Free Directional Light*/, #(0x1014L, 0x0L)/*Free Spot*/, #(0x1015L, 0x0L)/*Target directional light*/)
	#(#(0x1011L, 0x0L) /*Omnilight*/)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	#("Arnold Light")
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	#(48) --Light
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x6705f00dL, 0xca131d05L)/*Arnold Light*/
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	"Converts from a standard light to an Arnold Light"
)
--This internal function does the parameter mapping
fn ConvertSupportedParameters legacyLight arnoldLight =
(
	local ret = false
	if ((false == VerifySource legacyLight) or 
		(false == VerifyDestination arnoldLight)
		) do
	(
		--Not the suitable nodes
		return ret
	)		

	arnoldLight.cast_shadows = legacyLight.castShadows
	arnoldLight.color = legacyLight.rgb
	arnoldLight.shadow_color = legacyLight.shadowColor
	ret = true
	ret
)

fn CreateDestinationBasedOnSource legacyLight =
(	
	if (false == VerifySource legacyLight)  do
	(
		--Not the suitable node
		return undefined
	)
	
	local arnoldLight = undefined
	
	if(#omni == legacyLight.type) then
	(
		arnoldLight = Arnold_Light shapeType: 0 normalizeEnergyCbx: FALSE intensity:20 lightRadius:5
	) 
	else 
	(
		print ("Light type " + legacyLight.type + " not supported");
	)
	return arnoldLight;
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion legacyLight=
(
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyLight
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	local arnoldLight = Arnold_Light shapeType: 0  lightRadius:1
	
	--Call the parameters mapping function to convert
	local ret = ConvertSupportedParameters legacyLight arnoldLight
	if (ret == true) then (
		newLight			    = newNodesList[1]
		newLight.name        	= legacyLight.name --copy its name
		newLight.baseobject 	= arnoldLight.baseobject
		
		--Delete the dummy physical light from the scene
		delete arnoldLight
		
		--return the new created light node
		return newLight

	)
	else 
	(
		--Delete the dummy physical light from the scene
		delete arnoldLight
	)
	return undefined
)

--Main entry point from this script
--This function handles the node's creation
fn Conversion legacyLight =
(
	if (false == VerifySource legacyLight)  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyLight
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a Photometric light	
	local arnoldLight = CreateDestinationBasedOnSource legacyLight
	if (arnoldLight == undefined) do (
		return arnoldLight;
	)
	
	--Call the parameters mapping function to convert
	let ret = ConvertSupportedParameters legacyLight arnoldLight
	if (ret == true) then (
		newLight			    = newNodesList[1]
		newLight.name        	= legacyLight.name --copy its name
		newLight.baseobject 	= arnoldLight.baseobject
		
		--Delete the dummy physical light from the scene
		delete arnoldLight
		
		--return the new created light node
		return newLight

	)

	return undefined
)